// Set Changer.js
//
// 2013-01-17: firset release
//
// Hiroto Tsubaki tg@tres-graficos.jp
//


function buildUI( obj ) {
  
  obj.setParameter("name", "Set Changer");
  
  obj.addParameterSelector("set type", ["solo", "mute"], true, true);
  obj.addParameterInt("set number", 0, 0, 1000, true, true);
  
  obj.addParameterSeparator("Set Parameters");
  
  obj.addParameterBool("modeTagEditorActive", 1, 0, true, true);
  obj.addParameterBool("modeTagRenderActive", 1, 0, true, true);
  
  obj.addParameterSeparator("Update");
  
  obj.addParameterButton("set", "set", "setChange");
}

function setChange( obj ) {
  obj.update();
}

function buildObject( obj ) {
  
  var doc = obj.document();
  
  var list = [];
  list = collectList( doc.root(), list );  
  
  //
  
  var num = obj.getParameter("set number");
  var type = obj.getParameter("set type");
  
  var editorActive = obj.getParameter("modeTagEditorActive");
  var renderActive = obj.getParameter("modeTagRenderActive");
  
  var len = list.length;
  for (var i = 0;i < len;i++) {
    var o = list[i];
    
    var modeTag = tagWithType(o, 103);
    var tag = tagWithScriptName(o, "Set Changer Tag.js");
    var o_num = -1;
    var ignored = 1;
    if (tag) {
      o_num = tag.getParameter("set number");
      ignored = tag.getParameter("ignored");
    }
    
    if ( ignored || !modeTag ) continue;
    
    if (type == 0) { // solo
    
      if (o_num == num) { // visible
        if (editorActive) modeTag.setParameter("editorActive", true, false);
        if (renderActive) modeTag.setParameter("renderActive", true, false);
      } else {
        if (editorActive) modeTag.setParameter("editorActive", false, false);
        if (renderActive) modeTag.setParameter("renderActive", false, false);
      }
    
    } else if (type == 1) { // mute
    
      if (o_num == num) { // visible
        if (editorActive) modeTag.setParameter("editorActive", false, false);
        if (renderActive) modeTag.setParameter("renderActive", false, false);
      } else {
        if (editorActive) modeTag.setParameter("editorActive", true, false);
        if (renderActive) modeTag.setParameter("renderActive", true, false);
      }
    
    }
  }
  
}

function collectList( obj, list ) {
  
  var tag = tagWithScriptName( obj, "Set Changer Tag.js" );
  
  if (!tag) {
    var childCount = obj.childCount();
    
    for (var i = 0;i < childCount;i++) {
      var child = obj.childAtIndex(i);
      list.push( child );
      
      list = collectList( child, list );
    }
  }
  
  return list;
}

function tagWithType(obj, type) {
  var tagCount = obj.tagCount();
  var resultTag = false;
  for (var i = 0;i < tagCount;i++) {
  	var tag = obj.tagAtIndex(i);
  	if (tag.type() == type && tag.getParameter("tagOn")) {
  		resultTag = tag;
  	}
  }
  return resultTag;
}

function tagWithScriptName(obj, scriptName) {
	var tagCount = obj.tagCount();
	var resultTag = false;
	for (var i = 0;i < tagCount;i++) {
		var tag = obj.tagAtIndex(i);
        var sn = tag.getParameter("scriptName");
		if (sn.indexOf(scriptName) != -1 && tag.getParameter("tagOn")) {
			resultTag = tag;
		}
	}
	return resultTag;
}

